/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GrammarDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JRadioButton;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.FlexDescEditorShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class ButtonListener
implements ActionListener {
    private JDialog dialog;
    private JList listInputLang;
    private JList listOutputLang;
    private JRadioButton rdbtnRuleEditor;

    public ButtonListener(JDialog dialog, JList listInputLang, JList listOutputLang, JRadioButton rdbtnRuleEditor) {
        this.dialog = dialog;
        this.listInputLang = listInputLang;
        this.listOutputLang = listOutputLang;
        this.rdbtnRuleEditor = rdbtnRuleEditor;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String ilanguage = (String)this.listInputLang.getSelectedValue();
        Language ilan = new Language(ilanguage);
        String buttonText = ((JButton)arg0.getSource()).getText();
        GramType gt = buttonText.equals("Inflection & Derivation") ? GramType.FLX : (buttonText.equals("Productive Morphology") ? GramType.MORPHO : GramType.SYNTAX);
        Language olan = null;
        String olanguage = null;
        if (gt == GramType.FLX) {
            olanguage = (String)this.listInputLang.getSelectedValue();
            olan = new Language(ilanguage);
        } else {
            olanguage = (String)this.listOutputLang.getSelectedValue();
            olan = new Language(olanguage);
        }
        if (this.rdbtnRuleEditor.isSelected()) {
            FlexDescEditorShell rEditor = new FlexDescEditorShell();
            rEditor.getController().initLoad(gt, ilan, olan);
            Launcher.getDesktopPane().add(rEditor);
            rEditor.setVisible(true);
            this.dialog.dispose();
            return;
        }
        GrammarEditorShell gEditor = new GrammarEditorShell(ilan, olan);
        gEditor.getController().newGrammar(gt, ilanguage, olanguage, Launcher.preferences);
        Launcher.getDesktopPane().add(gEditor);
        gEditor.setVisible(true);
        this.dialog.dispose();
    }
}

